/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.qds.QDataSet;
import org.das2.qds.QFunction;
import org.das2.qds.ops.Ops;
import org.das2.util.AboutUtil;
import org.das2.util.LoggerManager;
import test.graph.QFunctionLarry;

public class Test039 {
    private static final boolean headless = "true".equals(System.getProperty("java.awt.headless"));

    private static void testTCA() throws ParseException, IOException {
        int width = 500;
        int height = 400;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        canvas.setAntiAlias(true);
        panel.add((Component)canvas, "Center");
        QDataSet yds = Ops.sin((QDataSet)Ops.linspace((double)0.0, (double)10.0, (int)1000));
        QDataSet tds = Ops.timegen((String)"2010-01-01T00:00", (String)"1 s", (int)1000);
        QDataSet ds = Ops.link((QDataSet)tds, (QDataSet)yds);
        DasAxis xaxis = GraphUtil.guessXAxis((QDataSet)ds);
        DasAxis yaxis = GraphUtil.guessYAxis((QDataSet)ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        Renderer r = GraphUtil.guessRenderer((QDataSet)ds);
        plot.addRenderer(r);
        if (r instanceof SeriesRenderer) {
            ((SeriesRenderer)r).setAntiAliased(true);
        }
        xaxis.setTcaFunction((QFunction)new QFunctionLarry());
        xaxis.setDrawTca(true);
        canvas.add((DasCanvasComponent)plot, DasRow.create((DasCanvas)canvas, null, (String)"0%+2em", (String)"100%-5em"), DasColumn.create((DasCanvas)canvas, null, (String)"0%+14em", (String)"100%-4em"));
        canvas.setPrintingTag("APL $Y");
        canvas.writeToPng("test039_tca.png");
    }

    public static void demoSpectrogram() throws IOException {
        try {
            QDataSet yds = Ops.pow((Object)10, (Object)Ops.linspace((double)3.0, (double)8.0, (int)30));
            QDataSet tds = Ops.timegen((String)"2015-03-31T00:00", (String)"30 min", (int)48);
            Ops.randomSeed((long)5334L);
            QDataSet zz = Ops.randn((int)48, (int)30);
            zz = Ops.link((QDataSet)tds, (QDataSet)yds, (QDataSet)zz);
            DasAxis xaxis = GraphUtil.guessXAxis((QDataSet)zz);
            DasAxis yaxis = new DasAxis(Datum.create((double)100.0, (Units)Units.dimensionless), Datum.create((double)1.0E9, (Units)Units.dimensionless), 3, true);
            DasPlot plot = new DasPlot(xaxis, yaxis);
            Renderer r = GraphUtil.guessRenderer((QDataSet)zz);
            plot.addRenderer(r);
            plot.setPreviewEnabled(true);
            DasCanvas canvas = new DasCanvas(600, 400);
            canvas.add((DasCanvasComponent)plot, DasRow.create((DasCanvas)canvas, null, (String)"0%+2em", (String)"100%-5em"), DasColumn.create((DasCanvas)canvas, null, (String)"0%+4em", (String)"100%-4em"));
            canvas.setPrintingTag("demoSpectrogram");
            canvas.writeToPng("test039_spectrogram.png");
            if (!headless) {
                JOptionPane.showMessageDialog(null, canvas);
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(Test039.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void demoTicks() throws IOException {
        try {
            QDataSet yds = Ops.pow((Object)10, (Object)Ops.linspace((double)3.0, (double)8.0, (int)30));
            QDataSet tds = Ops.timegen((String)"2015-03-31T00:00", (String)"30 min", (int)48);
            Ops.randomSeed((long)5334L);
            QDataSet zz = Ops.randn((int)48, (int)30);
            zz = Ops.link((QDataSet)tds, (QDataSet)yds, (QDataSet)zz);
            DasAxis xaxis = GraphUtil.guessXAxis((QDataSet)zz);
            DasAxis yaxis = new DasAxis(Datum.create((double)100.0, (Units)Units.dimensionless), Datum.create((double)1.0E9, (Units)Units.dimensionless), 3, true);
            DasPlot plot = new DasPlot(xaxis, yaxis);
            double[] ticks = new double[]{10000.0, 1000000.0, 1.0E8};
            yaxis.setTickV(ticks, ticks);
            Renderer r = GraphUtil.guessRenderer((QDataSet)zz);
            plot.addRenderer(r);
            plot.setPreviewEnabled(true);
            DasCanvas canvas = new DasCanvas(600, 400);
            canvas.add((DasCanvasComponent)plot, DasRow.create((DasCanvas)canvas, null, (String)"0%+2em", (String)"100%-5em"), DasColumn.create((DasCanvas)canvas, null, (String)"0%+7em", (String)"100%-4em"));
            canvas.setPrintingTag("demoTicks");
            canvas.writeToPng("test039_demoTicks.png");
            if (!headless) {
                JOptionPane.showMessageDialog(null, canvas);
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(Test039.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws Exception {
        String[] ss;
        String s = AboutUtil.getAboutHtml();
        for (String sss : ss = s.split("\\<br\\>")) {
            System.err.println(sss);
        }
        LoggerManager.getLogger((String)"das2.graphics.axis").setLevel(Level.ALL);
        if (args.length == 0 || args[0].contains("tca")) {
            Test039.testTCA();
        }
        if (args.length == 0 || args[0].contains("spectrogram")) {
            Test039.demoSpectrogram();
        }
        if (args.length == 0 || args[0].contains("ticks")) {
            Test039.demoTicks();
        }
        System.exit(0);
    }
}

